package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 订单实体类
 */
public class Order {
    @JsonProperty("mer_reference_id")
    private String merReferenceId;        //订单号商户生产保证交易唯一性的ID

    @JsonProperty("mer_date")
    private String merDate;                //商户订单日期

    private Amount amount;                //付款金额对象

    @JsonProperty("order_summary")
    private String orderSummary;        //订单简要说明

    @JsonProperty("expire_time")
    private String expireTime;            //过期时间

    @JsonProperty("user_ip")
    private String userIp;                //下单IP

    @JsonProperty("sub_orders")
    private List<SubOrder> subOrders;    //子订单信息对象

    Order() {
    }

    public Order(String merReferenceId, Amount amount, String orderSummary, String userIp) {
        this.merReferenceId = merReferenceId;
        this.merDate = DateFormatUtils.format(new Date(), "yyyyMMdd");
        this.amount = amount;
        this.amount.setCurrency(CurrencyType.CNY.toString());
        this.orderSummary = orderSummary;
        this.userIp = userIp;
        this.subOrders = new ArrayList<>();
    }

    public Order addSubOrder(SubOrder subOrder) {
        subOrders.add(subOrder);
        // setAmountTotal(subOrder);
        return this;
    }

    public void setAmountTotal(SubOrder subOrder) {
        double to = Double.parseDouble(this.amount.getTotal());
        to += Double.parseDouble(subOrder.getAmount().getTotal());
        String total = to + "";
        this.amount.setTotal(total);
    }

    public String getMerReferenceId() {
        return merReferenceId;
    }

    public void setMerReferenceId(String merReferenceId) {
        this.merReferenceId = merReferenceId;
    }

    public String getMerDate() {
        return merDate;
    }

    public void setMerDate(String merDate) {
        this.merDate = merDate;
    }

    public Amount getAmount() {
        return amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public String getOrderSummary() {
        return orderSummary;
    }

    public void setOrderSummary(String orderSummary) {
        this.orderSummary = orderSummary;
    }

    public String getExpireTime() {
        return expireTime;
    }

    void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getUserIp() {
        return userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public List<SubOrder> getSubOrders() {
        return subOrders;
    }

    public void setSubOrders(List<SubOrder> subOrders) {
        this.subOrders = subOrders;
    }

    public void expireTime(int seconds) {
        this.expireTime = seconds + "";
    }

}
