package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * 交易明细实体类
 */
public class Item {
    @JsonProperty("mer_item_id")
    private String merItemId;    //商品编号

    private ItemType type;        //商品类型

    private String name;        //商品名称

    @JsonProperty("quantity")
    private String quantity;    //商品数量

    private String description;    //商品描述

    private Amount amount;        //商品总金额对象

    Item() {

    }

    public Item(String merItemId, ItemType type, int quantity, Amount amount) {
        this.merItemId = merItemId;
        this.type = type;
        this.quantity = quantity + "";
        this.amount = amount;
    }

    public String getMerItemId() {
        return merItemId;
    }

    public void setMerItemId(String merItemId) {
        this.merItemId = merItemId;
    }

    public ItemType getType() {
        return type;
    }

    public void setType(ItemType type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQuantity() {
        return quantity;
    }

    public void setQuantity(String itemQuantity) {
        this.quantity = itemQuantity;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Amount getAmount() {
        return amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }
}
