package cn.payingcloud.umf.model;


import com.fasterxml.jackson.annotation.JsonProperty;

import java.text.DecimalFormat;


/**
 * 金额实体类
 */
public class Amount {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("######0.00");

    private String total;            //总金额,单位元,最多支持小数点后两位的数字

    private String currency;        //货币类型

    @JsonProperty("total_cny")
    private String totalCny;        //人民币金额,单位元,最多支持小数点后两位的数字

    @JsonProperty("exchange_rate")
    private ExchangeRate exchangeRate;//汇率

    Amount() {
    }

    public Amount(double total, CurrencyType currency) {
        this.total = DECIMAL_FORMAT.format(total);
        this.currency = currency == null ? null : currency.toString();
    }

    public String getTotal() {
        return total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getTotalCny() {
        return totalCny;
    }

    public void setTotalCny(String totalCny) {
        this.totalCny = totalCny;
    }

    public ExchangeRate getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(ExchangeRate exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

}
