/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.metrics.network;

import cn.patterncat.metrics.ExtraMetricsProperties;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.system.ApplicationPid;

public class ProcNetReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcNetReader.class);
    private String pid = new ApplicationPid().toString();
    private String SOCKSTAT_FILE = "/proc/net/sockstat";
    private String SNMP_FILE = "/proc/net/snmp";
    private String STAT_FILE = "/proc/" + this.pid + "/net/netstat";
    protected ConcurrentHashMap<String, Number> statData = new ConcurrentHashMap();
    private final ExtraMetricsProperties extraMetricsProperties;

    public ProcNetReader(ExtraMetricsProperties extraMetricsProperties) {
        this.extraMetricsProperties = extraMetricsProperties;
    }

    public Map<String, Number> query() {
        this.updateProcNetData();
        return this.statData;
    }

    public void updateProcNetData() {
        if (this.extraMetricsProperties.isSnmpEnabled()) {
            this.queryFile(this.SNMP_FILE, this.extraMetricsProperties.getSnmpCollectPrefixes());
        }
        if (this.extraMetricsProperties.isNetstatEnabled()) {
            this.queryFile(this.STAT_FILE, this.extraMetricsProperties.getNetstatCollectPrefixes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryFile(String file, List<String> prefixes) {
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((line = bufferedReader.readLine()) != null) {
                String[] keys = line.trim().split("\\s+");
                line = bufferedReader.readLine();
                String[] values = line.trim().split("\\s+");
                if (!prefixes.contains(keys[0].trim())) continue;
                for (int i = 0; i < keys.length; ++i) {
                    Double value = ProcNetReader.parseStringNumber(values[i], Double.NaN);
                    this.statData.put(keys[i], value);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static <NumberClass extends Number> NumberClass parseStringNumber(String toParse, NumberClass defaultVal) {
        if (toParse == null || "".equals(toParse)) {
            return defaultVal;
        }
        try {
            Class<?> clazz = defaultVal.getClass();
            Constructor<?> c = clazz.getConstructor(String.class);
            return (NumberClass)((Number)c.newInstance(toParse));
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return defaultVal;
    }
}

