/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.metrics.disk;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.io.File;

public class DiskMetrics
implements MeterBinder {
    private File rootFilePath;
    private String diskMetricsPrefix;
    Iterable<Tag> tags;

    public DiskMetrics(File rootFilePath, String diskMetricsPrefix) {
        this.rootFilePath = rootFilePath;
        this.diskMetricsPrefix = diskMetricsPrefix;
    }

    public DiskMetrics(Iterable<Tag> tags, String diskMetricsPrefix) {
        this.rootFilePath = new File(".");
        this.tags = tags;
        this.diskMetricsPrefix = diskMetricsPrefix;
    }

    public DiskMetrics(File rootFilePath, Iterable<Tag> tags) {
        this.rootFilePath = rootFilePath;
        this.tags = tags;
    }

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)(this.diskMetricsPrefix + ".total"), (Object)this.rootFilePath, c -> c.getTotalSpace()).tags(this.tags).register(registry);
        Gauge.builder((String)(this.diskMetricsPrefix + ".free"), (Object)this.rootFilePath, c -> c.getFreeSpace()).tags(this.tags).register(registry);
        Gauge.builder((String)(this.diskMetricsPrefix + ".usage"), (Object)this.rootFilePath, c -> {
            long totalDiskSpace = this.rootFilePath.getTotalSpace();
            if (totalDiskSpace == 0L) {
                return 0.0;
            }
            long usedDiskSpace = totalDiskSpace - this.rootFilePath.getFreeSpace();
            return Double.valueOf(usedDiskSpace) / (double)totalDiskSpace * 100.0;
        }).tags(this.tags).register(registry);
    }
}

