package cn.patterncat.metrics.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;

/**
 * Created by patterncat on 2018-03-18.
 */
public class NetworkHelper {

    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkHelper.class);

    public static String getHostName(){
        try {
            return InetAddress.getLocalHost().getHostName();
        } catch (UnknownHostException e) {
            LOGGER.warn(e.getMessage(),e);
            return UUID.randomUUID().toString();
        }
    }
}
