package cn.patterncat.metrics.network;

import cn.patterncat.metrics.ExtraMetricsProperties;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;

import java.util.Map;

/**
 * Created by patterncat on 2018-04-15.
 */
public class NetworkMetrics implements MeterBinder {

    ExtraMetricsProperties extraMetricsProperties;

    Iterable<Tag> tags;

    final ProcNetReader procNetReader;

    public NetworkMetrics(ExtraMetricsProperties extraMetricsProperties) {
        this.extraMetricsProperties = extraMetricsProperties;
        this.procNetReader = new ProcNetReader(extraMetricsProperties);
    }

    public NetworkMetrics(ExtraMetricsProperties extraMetricsProperties, Iterable<Tag> tags) {
        this(extraMetricsProperties);
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Map<String, Number> data = procNetReader.query();
        for(Map.Entry<String,Number> entry : data.entrySet()){
            Gauge.builder(extraMetricsProperties.getNetMetricsPrefix() + "."+entry.getKey(), procNetReader, c -> (double) c.query().get(entry.getKey()))
                    .description("extra net metrics from snmp and netstat")
                    .tags(tags)
                    .register(registry);
        }
    }
}
