package cn.patterncat.metrics.disk;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;

import java.io.File;

/**
 * iostat or /proc/diskstats currently not supported
 * Created by patterncat on 2018-04-15.
 */
public class DiskMetrics implements MeterBinder {

    private File rootFilePath;

    private String diskMetricsPrefix;

    Iterable<Tag> tags;

    public DiskMetrics(File rootFilePath,String diskMetricsPrefix) {
        this.rootFilePath = rootFilePath;
        this.diskMetricsPrefix = diskMetricsPrefix;
    }

    public DiskMetrics(Iterable<Tag> tags,String diskMetricsPrefix) {
        this.rootFilePath = new File(".");
        this.tags = tags;
        this.diskMetricsPrefix = diskMetricsPrefix;
    }

    public DiskMetrics(File rootFilePath, Iterable<Tag> tags) {
        this.rootFilePath = rootFilePath;
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder(diskMetricsPrefix + ".total", rootFilePath, c -> c.getTotalSpace())
                .tags(tags)
                .register(registry);
        Gauge.builder(diskMetricsPrefix + ".free", rootFilePath, c -> c.getFreeSpace())
                .tags(tags)
                .register(registry);
        Gauge.builder(diskMetricsPrefix + ".usage", rootFilePath, c -> {
            long totalDiskSpace = rootFilePath.getTotalSpace();
            if (totalDiskSpace == 0) {
                return 0.0;
            }

            long usedDiskSpace = totalDiskSpace - rootFilePath.getFreeSpace();
            return Double.valueOf(usedDiskSpace) / totalDiskSpace * 100;
        })
                .tags(tags)
                .register(registry);
    }
}
