package cn.patterncat.metrics;

import cn.patterncat.metrics.condition.LinuxCondition;
import cn.patterncat.metrics.disk.DiskMetrics;
import cn.patterncat.metrics.network.NetworkMetrics;
import cn.patterncat.metrics.utils.NetworkHelper;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

/**
 * Created by patterncat on 2018-12-11.
 */
@Configuration
@ConditionalOnProperty(name = "extra.metrics.enabled", havingValue = "true", matchIfMissing = true)
@EnableConfigurationProperties(ExtraMetricsProperties.class)
public class ExtraMetricsConfiguration {

    ExtraMetricsProperties extraMetricsProperties;

    public ExtraMetricsConfiguration(ExtraMetricsProperties extraMetricsProperties) {
        this.extraMetricsProperties = extraMetricsProperties;
    }

    @Value("${spring.application.name}")
    String application;

    @Bean
    MeterRegistryCustomizer<MeterRegistry> registerMetricsCommonTags() {
        return registry -> registry.config().commonTags(extraMetricsProperties.getAppCommonTagName(),application,
                extraMetricsProperties.getHostCommonTagName(),NetworkHelper.getHostName());
    }

    @Bean
    @ConditionalOnProperty(name = "extra.metrics.diskMetricsEnabled", havingValue = "true", matchIfMissing = true)
    public DiskMetrics diskMetrics(){
        return new DiskMetrics(extraMetricsProperties.getDiskMetricsPath(),extraMetricsProperties.getDiskMetricsPrefix());
    }

    @Bean
    @Conditional(LinuxCondition.class)
    @ConditionalOnProperty(name = "extra.metrics.netMetricsEnabled", havingValue = "true", matchIfMissing = true)
    public NetworkMetrics networkMetrics(){
        return new NetworkMetrics(extraMetricsProperties);
    }
}
