package cn.patterncat.cache.component.key;

import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;

import java.util.Collection;

/**
 * https://github.com/ipalbeniz/spring-boot-caches-endpoint/blob/master/src/main/java/com/demo/autoconfiguration/cachekeys/ConcurrentMapCacheKeysExtractor.java
 */
public class ConcurrentMapCacheKeysExtractor implements CacheKeysExtractor {

    @Override
    public Collection extractKeys(Cache cache) {

        return ((ConcurrentMapCache)cache).getNativeCache().keySet();
    }
}
