package cn.patterncat.cache.component.key;

import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;

import java.util.Collection;

/**
 * Created by cat on 2019-03-12.
 */
public class CaffeineCacheKeysExtractor implements CacheKeysExtractor{
    @Override
    public Collection extractKeys(Cache cache) {
        CaffeineCache caffeineCache = (CaffeineCache) cache;
        return caffeineCache.getNativeCache().asMap().keySet();
    }
}
