package cn.patterncat.cache.component;

import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.SimpleCacheResolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/**
 * Created by cat on 2019-03-12.
 */
public class CascadeCacheResolver extends SimpleCacheResolver {

    public CascadeCacheResolver() {
    }

    public CascadeCacheResolver(CacheManager cacheManager) {
        super(cacheManager);
    }

    @Override
    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        Collection<String> cacheNames = getCacheNames(context);
        if (cacheNames == null) {
            return Collections.emptyList();
        }
        Collection<Cache> result = new ArrayList<>(cacheNames.size());
        for (String cacheName : cacheNames) {
            CacheManager cacheManager = getCacheManager();
            if(cacheManager instanceof CascadeCacheManager){
                ((CascadeCacheManager) cacheManager).getCacheManagers()
                        .stream()
                        .forEach(m -> {
                            Cache cache = m.getCache(cacheName);
                            result.add(cache);
                        });
            }else{
                Cache cache = cacheManager.getCache(cacheName);
                if (cache == null) {
                    throw new IllegalArgumentException("Cannot find cache named '" +
                            cacheName + "' for " + context.getOperation());
                }
                result.add(cache);
            }

        }
        return result;
    }
}
