package cn.patterncat.cache.component;

import org.springframework.cache.CacheManager;
import org.springframework.cache.support.CompositeCacheManager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Created by cat on 2019-03-12.
 */
public class CascadeCacheManager extends CompositeCacheManager {

    List<CacheManager> cacheManagers = new ArrayList<>();

    public CascadeCacheManager() {
    }

    @Override
    public void setCacheManagers(Collection<CacheManager> cacheManagers) {
        super.setCacheManagers(cacheManagers);
        this.cacheManagers.addAll(cacheManagers);
    }

    public List<CacheManager> getCacheManagers() {
        return cacheManagers;
    }
}
