/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.webdriver.component;

import cn.patterncat.webdriver.component.DriverProcessor;
import cn.patterncat.webdriver.component.WebDriverPool;
import cn.patterncat.webdriver.exception.NoDriverAvailableException;
import java.util.NoSuchElementException;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverTemplate.class);
    WebDriverPool pool;

    public WebDriverTemplate(WebDriverPool pool) {
        this.pool = pool;
    }

    public <T> T execute(long timeoutInMs, DriverProcessor<T> processor) throws Exception {
        PhantomJSDriver driver = null;
        try {
            T result;
            driver = this.pool.borrowObject(timeoutInMs);
            T t = result = processor.execute(driver);
            return t;
        }
        catch (NoSuchElementException e) {
            throw new NoDriverAvailableException(e.getMessage(), e);
        }
        finally {
            if (driver != null) {
                this.pool.returnObject(driver);
            }
        }
    }
}

