/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.webdriver.component;

import cn.patterncat.webdriver.WebDriverProperties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledDriverFactory
extends BasePooledObjectFactory<PhantomJSDriver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledDriverFactory.class);
    DesiredCapabilities dcaps;
    WebDriverProperties properties;

    public PooledDriverFactory(DesiredCapabilities dcaps, WebDriverProperties properties) {
        this.dcaps = dcaps;
        this.properties = properties;
    }

    public PhantomJSDriver create() throws Exception {
        PhantomJSDriver driver = new PhantomJSDriver((Capabilities)this.dcaps);
        driver.setLogLevel(Level.INFO);
        driver.manage().timeouts().pageLoadTimeout((long)this.properties.getPageLoadTimeoutMs(), TimeUnit.MILLISECONDS);
        driver.manage().timeouts().setScriptTimeout((long)this.properties.getScriptLoadTimeoutMs(), TimeUnit.MILLISECONDS);
        driver.manage().timeouts().implicitlyWait((long)this.properties.getImplicitlyWaitMs(), TimeUnit.MILLISECONDS);
        return driver;
    }

    public PooledObject<PhantomJSDriver> wrap(PhantomJSDriver obj) {
        return new DefaultPooledObject((Object)obj);
    }

    public void passivateObject(PooledObject<PhantomJSDriver> p) throws Exception {
        super.passivateObject(p);
    }

    public void activateObject(PooledObject<PhantomJSDriver> p) throws Exception {
        super.activateObject(p);
    }

    public boolean validateObject(PooledObject<PhantomJSDriver> p) {
        return super.validateObject(p);
    }

    public void destroyObject(PooledObject<PhantomJSDriver> p) throws Exception {
        PhantomJSDriver driver = (PhantomJSDriver)p.getObject();
        try {
            driver.quit();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public PooledObject<PhantomJSDriver> makeObject() throws Exception {
        return super.makeObject();
    }
}

