/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.webdriver;

import cn.patterncat.webdriver.WebDriverProperties;
import cn.patterncat.webdriver.component.PooledDriverFactory;
import cn.patterncat.webdriver.component.WebDriverPool;
import cn.patterncat.webdriver.component.WebDriverTemplate;
import java.io.File;
import net.anthavio.phanbedder.Phanbedder;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StopWatch;

@Configuration
@ConditionalOnClass(value={PhantomJSDriver.class})
@ConditionalOnProperty(prefix="webdriver", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={WebDriverProperties.class})
public class WebDriverAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverAutoConfiguration.class);
    private static final String USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11";
    private final WebDriverProperties properties;

    public WebDriverAutoConfiguration(WebDriverProperties properties) {
        this.properties = properties;
    }

    @Bean
    public PooledDriverFactory pooledDriverFactory() {
        File phantomjs = Phanbedder.unpack();
        DesiredCapabilities dcaps = new DesiredCapabilities();
        dcaps.setCapability("phantomjs.binary.path", phantomjs.getAbsolutePath());
        dcaps.setCapability("phantomjs.page.settings.userAgent", USER_AGENT);
        PooledDriverFactory factory = new PooledDriverFactory(dcaps, this.properties);
        return factory;
    }

    @Bean(destroyMethod="close")
    public WebDriverPool webDriverPool() {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(this.properties.getPoolMaxTotal());
        poolConfig.setMinIdle(this.properties.getPoolMinIdle());
        poolConfig.setMaxIdle(this.properties.getPoolMaxIdle());
        return new WebDriverPool((PooledObjectFactory<PhantomJSDriver>)this.pooledDriverFactory(), poolConfig);
    }

    @Bean
    public WebDriverTemplate webDriverTemplate(WebDriverPool pool) {
        return new WebDriverTemplate(pool);
    }

    @Bean
    public CommandLineRunner preparePoolRunner(final WebDriverPool pool) {
        return new CommandLineRunner(){

            public void run(String ... strings) throws Exception {
                if (WebDriverAutoConfiguration.this.properties.isPreparePool()) {
                    StopWatch stopWatch = new StopWatch("prepare pool");
                    stopWatch.start();
                    LOGGER.info("start to prepare pool size:{}", (Object)WebDriverAutoConfiguration.this.properties.getPoolMinIdle());
                    pool.preparePool();
                    stopWatch.stop();
                    LOGGER.info("finish prepare pool size:{},cost:{}", (Object)WebDriverAutoConfiguration.this.properties.getPoolMinIdle(), (Object)stopWatch.prettyPrint());
                }
            }
        };
    }
}

