/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.elasticsearch.config;

import cn.patterncat.elasticsearch.component.EsDataSourceBeanPostProcessor;
import cn.patterncat.elasticsearch.component.EsDataSourceHealthIndicator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

@Configuration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class EsDataSourceConfig {
    @Bean
    public EsDataSourceBeanPostProcessor esDataSourceBeanPostProcessor(DataSourceProperties dataSourceProperties) {
        return new EsDataSourceBeanPostProcessor(dataSourceProperties);
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.datasource.health-indicator.enabled"}, havingValue="true", matchIfMissing=false)
    public static class EsDataSourceHealthIndicatorAutoConfiguration
    extends CompositeHealthIndicatorConfiguration<EsDataSourceHealthIndicator, DataSource> {
        @Bean
        public HealthIndicator dbHealthIndicator(Map<String, DataSource> dataSources) {
            Map<String, DataSource> map = this.filterDataSources(dataSources);
            return this.createHealthIndicator(map);
        }

        protected EsDataSourceHealthIndicator createHealthIndicator(DataSource source) {
            return new EsDataSourceHealthIndicator(source);
        }

        private Map<String, DataSource> filterDataSources(Map<String, DataSource> candidates) {
            if (candidates == null) {
                return null;
            }
            LinkedHashMap<String, DataSource> dataSources = new LinkedHashMap<String, DataSource>();
            candidates.forEach((name, dataSource) -> {
                if (!(dataSource instanceof AbstractRoutingDataSource)) {
                    dataSources.put((String)name, (DataSource)dataSource);
                }
            });
            return dataSources;
        }
    }
}

