/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.elasticsearch.component;

import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class EsDataSourceHealthIndicator
extends AbstractHealthIndicator {
    private DataSource dataSource;

    public EsDataSourceHealthIndicator(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.up().withDetail("database", (Object)"Elasticsearch");
        Connection con = DataSourceUtils.getConnection((DataSource)this.dataSource);
        boolean isHealth = false;
        try {
            isHealth = con.isValid(100);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.dataSource);
        }
        builder.withDetail("health", (Object)isHealth);
    }
}

