/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.elasticsearch.component;

import com.amazon.opendistroforelasticsearch.jdbc.ElasticsearchDataSource;
import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class EsDataSourceBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EsDataSourceBeanPostProcessor.class);
    DataSourceProperties dataSourceProperties;

    public EsDataSourceBeanPostProcessor(DataSourceProperties dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ElasticsearchDataSource) {
            ElasticsearchDataSource dataSource = (ElasticsearchDataSource)bean;
            Properties properties = new Properties();
            properties.put("user", this.dataSourceProperties.getUsername());
            properties.put("password", this.dataSourceProperties.getPassword());
            try {
                dataSource.setProperties(properties);
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return dataSource;
        }
        return bean;
    }
}

