/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.sentinel.jdbc.service;

import cn.patterncat.helper.sql.builder.JpaSpecBuilder;
import cn.patterncat.sentinel.jdbc.config.SentinelJdbcProperties;
import cn.patterncat.sentinel.jdbc.dao.SentinelRuleDao;
import cn.patterncat.sentinel.jdbc.domain.SentinelRule;
import cn.patterncat.sentinel.jdbc.domain.SentinelRuleType;
import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SentinelRuleService {
    @Autowired
    SentinelRuleDao sentinelRuleDao;

    public SentinelRule findTopRuleTypeOrderByCreatedDateDesc(SentinelJdbcProperties properties, SentinelRuleType ruleType) {
        Page page;
        JpaSpecBuilder specBuilder = JpaSpecBuilder.newInstance();
        specBuilder.and((Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("ruleType"), (Object)ruleType));
        specBuilder.and((Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("appId"), (Object)properties.getAppId()));
        if (StringUtils.hasText((String)properties.getNamespace())) {
            specBuilder.and((Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("namespace"), (Object)properties.getNamespace()));
        }
        if (StringUtils.hasText((String)properties.getProfile())) {
            specBuilder.and((Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("profile"), (Object)properties.getProfile()));
        }
        if ((page = this.sentinelRuleDao.findAll(specBuilder.build(), (Pageable)PageRequest.of((int)0, (int)1, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdDate"}))).hasContent()) {
            return (SentinelRule)((Object)page.getContent().get(0));
        }
        return null;
    }

    public SentinelRule save(SentinelRule rule) {
        return (SentinelRule)((Object)this.sentinelRuleDao.save((Object)rule));
    }
}

