/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.sentinel.jdbc.domain;

import cn.patterncat.sentinel.jdbc.domain.SentinelRuleType;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Version;
import org.springframework.data.jpa.domain.AbstractPersistable;

@Entity
@Table(name="sentinel_rule")
public class SentinelRule
extends AbstractPersistable<Long> {
    private String namespace;
    private String appId;
    private String profile;
    @Enumerated(value=EnumType.STRING)
    private SentinelRuleType ruleType;
    @Column(length=3000)
    private String value;
    private LocalDateTime createdDate;
    @Version
    private Long version;
    private boolean deleted;

    public SentinelRule() {
    }

    private static String $default$namespace() {
        return "ns";
    }

    private static String $default$appId() {
        return "app";
    }

    private static String $default$profile() {
        return "default";
    }

    private static String $default$value() {
        return "[]";
    }

    private static LocalDateTime $default$createdDate() {
        return LocalDateTime.now();
    }

    SentinelRule(String namespace, String appId, String profile, SentinelRuleType ruleType, String value, LocalDateTime createdDate, Long version, boolean deleted) {
        this.namespace = namespace;
        this.appId = appId;
        this.profile = profile;
        this.ruleType = ruleType;
        this.value = value;
        this.createdDate = createdDate;
        this.version = version;
        this.deleted = deleted;
    }

    public static SentinelRuleBuilder builder() {
        return new SentinelRuleBuilder();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getProfile() {
        return this.profile;
    }

    public SentinelRuleType getRuleType() {
        return this.ruleType;
    }

    public String getValue() {
        return this.value;
    }

    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    public Long getVersion() {
        return this.version;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setRuleType(SentinelRuleType ruleType) {
        this.ruleType = ruleType;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SentinelRule)) {
            return false;
        }
        SentinelRule other = (SentinelRule)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        SentinelRuleType this$ruleType = this.getRuleType();
        SentinelRuleType other$ruleType = other.getRuleType();
        if (this$ruleType == null ? other$ruleType != null : !((Object)((Object)this$ruleType)).equals((Object)other$ruleType)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        LocalDateTime this$createdDate = this.getCreatedDate();
        LocalDateTime other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        return this.isDeleted() == other.isDeleted();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SentinelRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        SentinelRuleType $ruleType = this.getRuleType();
        result = result * 59 + ($ruleType == null ? 43 : ((Object)((Object)$ruleType)).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        LocalDateTime $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SentinelRule(namespace=" + this.getNamespace() + ", appId=" + this.getAppId() + ", profile=" + this.getProfile() + ", ruleType=" + this.getRuleType() + ", value=" + this.getValue() + ", createdDate=" + this.getCreatedDate() + ", version=" + this.getVersion() + ", deleted=" + this.isDeleted() + ")";
    }

    public static class SentinelRuleBuilder {
        private boolean namespace$set;
        private String namespace;
        private boolean appId$set;
        private String appId;
        private boolean profile$set;
        private String profile;
        private SentinelRuleType ruleType;
        private boolean value$set;
        private String value;
        private boolean createdDate$set;
        private LocalDateTime createdDate;
        private Long version;
        private boolean deleted;

        SentinelRuleBuilder() {
        }

        public SentinelRuleBuilder namespace(String namespace) {
            this.namespace = namespace;
            this.namespace$set = true;
            return this;
        }

        public SentinelRuleBuilder appId(String appId) {
            this.appId = appId;
            this.appId$set = true;
            return this;
        }

        public SentinelRuleBuilder profile(String profile) {
            this.profile = profile;
            this.profile$set = true;
            return this;
        }

        public SentinelRuleBuilder ruleType(SentinelRuleType ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        public SentinelRuleBuilder value(String value) {
            this.value = value;
            this.value$set = true;
            return this;
        }

        public SentinelRuleBuilder createdDate(LocalDateTime createdDate) {
            this.createdDate = createdDate;
            this.createdDate$set = true;
            return this;
        }

        public SentinelRuleBuilder version(Long version) {
            this.version = version;
            return this;
        }

        public SentinelRuleBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public SentinelRule build() {
            String namespace = this.namespace;
            if (!this.namespace$set) {
                namespace = SentinelRule.$default$namespace();
            }
            String appId = this.appId;
            if (!this.appId$set) {
                appId = SentinelRule.$default$appId();
            }
            String profile = this.profile;
            if (!this.profile$set) {
                profile = SentinelRule.$default$profile();
            }
            String value = this.value;
            if (!this.value$set) {
                value = SentinelRule.$default$value();
            }
            LocalDateTime createdDate = this.createdDate;
            if (!this.createdDate$set) {
                createdDate = SentinelRule.$default$createdDate();
            }
            return new SentinelRule(namespace, appId, profile, this.ruleType, value, createdDate, this.version, this.deleted);
        }

        public String toString() {
            return "SentinelRule.SentinelRuleBuilder(namespace=" + this.namespace + ", appId=" + this.appId + ", profile=" + this.profile + ", ruleType=" + this.ruleType + ", value=" + this.value + ", createdDate=" + this.createdDate + ", version=" + this.version + ", deleted=" + this.deleted + ")";
        }
    }
}

