/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.sentinel.jdbc.config;

import cn.patterncat.sentinel.jdbc.component.FixedModifyRulesCommandHandler;
import cn.patterncat.sentinel.jdbc.component.RuleDataSourceRegister;
import cn.patterncat.sentinel.jdbc.config.SentinelJdbcProperties;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.transport.command.SimpleHttpCommandCenter;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.alibaba.sentinel.custom.SentinelAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@AutoConfigureAfter(value={SentinelAutoConfiguration.class})
@Configuration
@EnableConfigurationProperties(value={SentinelJdbcProperties.class})
@ComponentScan(value={"cn.patterncat.sentinel.jdbc.component", "cn.patterncat.sentinel.jdbc.service"})
public class SentinelRuleConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentinelConfig.class);

    @PostConstruct
    public void init() {
        try {
            Field field = SimpleHttpCommandCenter.class.getDeclaredField("handlerMap");
            field.setAccessible(true);
            Map handlerMap = (Map)field.get(null);
            handlerMap.put("setRules", new FixedModifyRulesCommandHandler());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Bean
    public RuleDataSourceRegister ruleDataSourceRegister(SentinelJdbcProperties sentinelJdbcProperties) {
        return new RuleDataSourceRegister(sentinelJdbcProperties);
    }
}

