/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.sentinel.jdbc.component;

import cn.patterncat.sentinel.jdbc.component.JdbcReadDataSource;
import cn.patterncat.sentinel.jdbc.component.JdbcWriteDataSource;
import cn.patterncat.sentinel.jdbc.component.JsonRuleConverter;
import cn.patterncat.sentinel.jdbc.component.MinutesDegradeRule;
import cn.patterncat.sentinel.jdbc.config.SentinelJdbcProperties;
import cn.patterncat.sentinel.jdbc.domain.SentinelRuleType;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.transport.util.WritableDataSourceRegistry;
import com.alibaba.fastjson.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;

public class RuleDataSourceRegister {
    private SentinelJdbcProperties properties;

    public RuleDataSourceRegister(SentinelJdbcProperties properties) {
        this.properties = properties;
    }

    @PostConstruct
    public void init() {
        this.registerJdbcRuleDataSource();
    }

    public void registerJdbcRuleDataSource() {
        JdbcReadDataSource flowRuleDataSource = new JdbcReadDataSource(this.properties, SentinelRuleType.FLOW, new JsonRuleConverter((TypeReference)new TypeReference<List<FlowRule>>(){}));
        flowRuleDataSource.loadInitialConfig();
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
        JdbcReadDataSource degradeRuleDataSource = new JdbcReadDataSource(this.properties, SentinelRuleType.DEGRADE, new JsonRuleConverter((TypeReference)new TypeReference<List<MinutesDegradeRule>>(){}));
        degradeRuleDataSource.loadInitialConfig();
        DegradeRuleManager.register2Property((SentinelProperty)degradeRuleDataSource.getProperty());
        JdbcReadDataSource systemRuleDataSource = new JdbcReadDataSource(this.properties, SentinelRuleType.SYSTEM, new JsonRuleConverter((TypeReference)new TypeReference<List<SystemRule>>(){}));
        systemRuleDataSource.loadInitialConfig();
        SystemRuleManager.register2Property((SentinelProperty)systemRuleDataSource.getProperty());
        JdbcReadDataSource authorityRuleDataSource = new JdbcReadDataSource(this.properties, SentinelRuleType.AUTHORITY, new JsonRuleConverter((TypeReference)new TypeReference<List<AuthorityRule>>(){}));
        authorityRuleDataSource.loadInitialConfig();
        AuthorityRuleManager.register2Property((SentinelProperty)authorityRuleDataSource.getProperty());
        WritableDataSourceRegistry.registerFlowDataSource(new JdbcWriteDataSource(this.properties, SentinelRuleType.FLOW));
        WritableDataSourceRegistry.registerDegradeDataSource(new JdbcWriteDataSource(this.properties, SentinelRuleType.DEGRADE));
        WritableDataSourceRegistry.registerSystemDataSource(new JdbcWriteDataSource(this.properties, SentinelRuleType.SYSTEM));
        WritableDataSourceRegistry.registerAuthorityDataSource(new JdbcWriteDataSource(this.properties, SentinelRuleType.AUTHORITY));
    }
}

