/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.sentinel.jdbc.component;

import cn.patterncat.sentinel.jdbc.component.ApplicationContextHolder;
import cn.patterncat.sentinel.jdbc.config.SentinelJdbcProperties;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.StatisticNode;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import com.alibaba.csp.sentinel.slots.statistic.metric.Metric;
import java.lang.reflect.Field;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinutesDegradeRule
extends DegradeRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinutesDegradeRule.class);
    private volatile boolean cut = false;
    protected int rtMaxExceed;
    private final Object lock = new Object();
    private static Field field;
    protected static ScheduledExecutorService pool;

    public MinutesDegradeRule() {
        SentinelJdbcProperties properties = (SentinelJdbcProperties)ApplicationContextHolder.getContext().getBean(SentinelJdbcProperties.class);
        this.rtMaxExceed = properties.getRtMaxExceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passCheck(Context context, DefaultNode node, int acquireCount, Object ... args) {
        double exception;
        if (this.cut) {
            return false;
        }
        ClusterNode clusterNode = ClusterBuilderSlot.getClusterNode((String)this.getResource());
        if (clusterNode == null) {
            return true;
        }
        if (this.getGrade() == 0) {
            double rt = clusterNode.avgRt();
            if (rt == 0.0) {
                try {
                    Metric metric = (Metric)field.get(clusterNode);
                    rt = metric.rt();
                    LOGGER.debug("rt in minutes:{}", (Object)rt);
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
            if (rt < this.getCount()) {
                this.getPassCount().set(0L);
                return true;
            }
            if (this.getPassCount().incrementAndGet() < (long)this.rtMaxExceed) {
                return true;
            }
        } else if (this.getGrade() == 1) {
            exception = clusterNode.exceptionQps();
            double success = clusterNode.successQps();
            long total = clusterNode.totalQps();
            if (total < (long)this.rtMaxExceed) {
                return true;
            }
            double realSuccess = success - exception;
            if (realSuccess <= 0.0 && exception < (double)this.rtMaxExceed) {
                return true;
            }
            if (exception / success < this.getCount()) {
                return true;
            }
        } else if (this.getGrade() == 2 && (exception = (double)clusterNode.totalException()) < this.getCount()) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCut()) {
                this.cut = true;
                ResetTask resetTask = new ResetTask(this);
                pool.schedule(resetTask, (long)this.getTimeWindow(), TimeUnit.SECONDS);
            }
            return false;
        }
    }

    public void setCut(boolean cut) {
        this.cut = cut;
    }

    static {
        try {
            field = StatisticNode.class.getDeclaredField("rollingCounterInMinute");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        pool = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new NamedThreadFactory("sentinel-degrade-reset-task", true));
    }

    private static final class ResetTask
    implements Runnable {
        private MinutesDegradeRule rule;

        ResetTask(MinutesDegradeRule rule) {
            this.rule = rule;
        }

        @Override
        public void run() {
            this.rule.getPassCount().set(0L);
            this.rule.setCut(false);
        }
    }
}

