/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.sentinel.jdbc.component;

import cn.patterncat.sentinel.jdbc.component.ApplicationContextHolder;
import cn.patterncat.sentinel.jdbc.config.SentinelJdbcProperties;
import cn.patterncat.sentinel.jdbc.domain.SentinelRule;
import cn.patterncat.sentinel.jdbc.domain.SentinelRuleType;
import cn.patterncat.sentinel.jdbc.service.SentinelRuleService;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import com.alibaba.fastjson.JSON;
import java.util.List;

public class JdbcWriteDataSource<T>
implements WritableDataSource<List<T>> {
    SentinelJdbcProperties properties;
    SentinelRuleService sentinelRuleService;
    SentinelRuleType ruleType;

    public JdbcWriteDataSource(SentinelJdbcProperties properties, SentinelRuleType ruleType) {
        this.properties = properties;
        this.ruleType = ruleType;
        this.sentinelRuleService = (SentinelRuleService)ApplicationContextHolder.getContext().getBean(SentinelRuleService.class);
    }

    public void write(List<T> value) throws Exception {
        SentinelRule rule = this.sentinelRuleService.findTopRuleTypeOrderByCreatedDateDesc(this.properties, this.ruleType);
        String json = JSON.toJSONString(value);
        if (rule == null) {
            rule = SentinelRule.builder().ruleType(this.ruleType).appId(this.properties.getAppId()).namespace(this.properties.getNamespace()).profile(this.properties.getProfile()).value(json).build();
        } else {
            rule.setValue(json);
        }
        this.sentinelRuleService.save(rule);
    }

    public void close() throws Exception {
    }
}

