/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.sentinel.jdbc.component;

import cn.patterncat.sentinel.jdbc.component.ApplicationContextHolder;
import cn.patterncat.sentinel.jdbc.config.SentinelJdbcProperties;
import cn.patterncat.sentinel.jdbc.domain.SentinelRule;
import cn.patterncat.sentinel.jdbc.domain.SentinelRuleType;
import cn.patterncat.sentinel.jdbc.service.SentinelRuleService;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.List;

public class JdbcReadDataSource<T>
extends AbstractDataSource<String, List<T>> {
    SentinelJdbcProperties properties;
    SentinelRuleService sentinelRuleService;
    SentinelRuleType ruleType;

    public JdbcReadDataSource(SentinelJdbcProperties properties, SentinelRuleType ruleType, Converter<String, List<T>> parser) {
        super(parser);
        this.properties = properties;
        this.ruleType = ruleType;
        this.sentinelRuleService = (SentinelRuleService)ApplicationContextHolder.getContext().getBean(SentinelRuleService.class);
    }

    public String readSource() throws Exception {
        SentinelRule rule = this.sentinelRuleService.findTopRuleTypeOrderByCreatedDateDesc(this.properties, this.ruleType);
        return rule == null ? null : rule.getValue();
    }

    public void close() throws Exception {
    }

    public void loadInitialConfig() {
        try {
            List newValue = (List)this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"WARN: initial config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue((Object)newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"Error when loading initial config", (Throwable)ex);
        }
    }
}

