/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.sentinel.jdbc.component;

import cn.patterncat.sentinel.jdbc.component.MinutesDegradeRule;
import cn.patterncat.sentinel.jdbc.domain.SentinelRuleType;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.transport.util.WritableDataSourceRegistry;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import java.net.URLDecoder;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandMapping(name="setRules")
public class FixedModifyRulesCommandHandler
implements CommandHandler<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedModifyRulesCommandHandler.class);
    private static final String WRITE_DS_FAILURE_MSG = "partial success (write data source failed)";

    public CommandResponse<String> handle(CommandRequest request) {
        String type = request.getParam("type");
        String data = request.getParam("data");
        if (StringUtil.isNotEmpty((String)data)) {
            try {
                data = URLDecoder.decode(data, "utf-8");
            }
            catch (Exception e2) {
                RecordLog.info((String)"Decode rule data error", (Throwable)e2);
                return CommandResponse.ofFailure((Throwable)e2, (Object)"decode rule data error");
            }
        }
        RecordLog.info((String)String.format("Receiving rule change (type: %s): %s", type, data), (Object[])new Object[0]);
        String result = "success";
        if (SentinelRuleType.FLOW.name().equalsIgnoreCase(type)) {
            List flowRules = JSONArray.parseArray((String)data, FlowRule.class);
            FlowRuleManager.loadRules((List)flowRules);
            if (!this.writeToDataSource(WritableDataSourceRegistry.getFlowDataSource(), flowRules)) {
                result = WRITE_DS_FAILURE_MSG;
            }
            return CommandResponse.ofSuccess((Object)result);
        }
        if (SentinelRuleType.AUTHORITY.name().equalsIgnoreCase(type)) {
            List rules = JSONArray.parseArray((String)data, AuthorityRule.class);
            AuthorityRuleManager.loadRules((List)rules);
            if (!this.writeToDataSource(WritableDataSourceRegistry.getAuthorityDataSource(), rules)) {
                result = WRITE_DS_FAILURE_MSG;
            }
            return CommandResponse.ofSuccess((Object)result);
        }
        if (SentinelRuleType.DEGRADE.name().equalsIgnoreCase(type)) {
            List rules = JSONArray.parseArray((String)data, MinutesDegradeRule.class);
            List fixed = rules.stream().map(e -> e).collect(Collectors.toList());
            DegradeRuleManager.loadRules(fixed);
            if (!this.writeToDataSource(WritableDataSourceRegistry.getDegradeDataSource(), fixed)) {
                result = WRITE_DS_FAILURE_MSG;
            }
            return CommandResponse.ofSuccess((Object)result);
        }
        if (SentinelRuleType.SYSTEM.name().equalsIgnoreCase(type)) {
            List rules = JSONArray.parseArray((String)data, SystemRule.class);
            SystemRuleManager.loadRules((List)rules);
            if (!this.writeToDataSource(WritableDataSourceRegistry.getSystemSource(), rules)) {
                result = WRITE_DS_FAILURE_MSG;
            }
            return CommandResponse.ofSuccess((Object)result);
        }
        return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("invalid type"));
    }

    private <T> boolean writeToDataSource(WritableDataSource<T> dataSource, T value) {
        if (dataSource != null) {
            try {
                dataSource.write(value);
            }
            catch (Exception e) {
                RecordLog.warn((String)"Write data source failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

