/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.ribbon.predicate;

import cn.patterncat.ribbon.api.RibbonFilterContext;
import cn.patterncat.ribbon.support.RibbonFilterContextHolder;
import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.PredicateKey;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class MetadataAwarePredicate
extends AbstractServerPredicate {
    public boolean apply(PredicateKey input) {
        if (input == null || !(input.getServer() instanceof DiscoveryEnabledServer)) {
            return true;
        }
        return this.applyByServer((DiscoveryEnabledServer)input.getServer());
    }

    protected boolean applyByServer(DiscoveryEnabledServer server) {
        RibbonFilterContext context = RibbonFilterContextHolder.getCurrentContext();
        Set<Map.Entry<String, String>> attributes = Collections.unmodifiableSet(context.getAttributes().entrySet());
        Map metadata = server.getInstanceInfo().getMetadata();
        boolean result = metadata.entrySet().containsAll(attributes);
        RibbonFilterContextHolder.clearCurrentContext();
        return result;
    }
}

