/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.service;

import cn.patterncat.rsq.dao.pg.QueryDefinitionDao;
import cn.patterncat.rsq.model.QueryAuthInfo;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class YamlExportService {
    private static final FilterProvider FILTER_PROVIDER = new SimpleFilterProvider().addFilter("queryDefinitionAttributeFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"createdBy", "createdDate", "lastModifiedBy", "lastModifiedDate", "version", "deleted", "new"}));
    ObjectMapper yamlObjectMapper;
    YAMLFactory yamlFactory = new YAMLFactory();
    @Autowired
    QueryDefinitionDao queryDefinitionDao;
    @Autowired
    List<QueryAuthInfo> defaultAuthInfos;

    public YamlExportService() {
        this.yamlObjectMapper = new ObjectMapper((JsonFactory)this.yamlFactory);
        this.yamlObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.yamlObjectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.yamlObjectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.yamlObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.yamlObjectMapper.addMixIn(Object.class, O000000o.class);
    }

    public String exportYamlAsString() throws JsonProcessingException {
        List list = this.queryDefinitionDao.findAll();
        ObjectWriter objectWriter = this.yamlObjectMapper.writer(FILTER_PROVIDER).withDefaultPrettyPrinter();
        return objectWriter.writeValueAsString((Object)list);
    }

    @JsonFilter(value="queryDefinitionAttributeFilter")
    class O000000o {
        O000000o() {
        }
    }
}

