/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.service;

import cn.patterncat.rsq.dao.pg.QueryDefinitionDao;
import cn.patterncat.rsq.domain.pg.QueryDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class QueryDefinitionService {
    @Autowired
    QueryDefinitionDao queryDefinitionDao;

    public Page<QueryDefinition> findAll(Specification<QueryDefinition> spec, Pageable pageable) {
        return this.queryDefinitionDao.findAll(spec, pageable);
    }

    @CacheEvict(value={"rsqSqlDefCache"}, key="#queryId")
    public void delete(String queryId) {
        QueryDefinition queryDefinition = this.queryDefinitionDao.findByQueryId(queryId);
        if (queryDefinition != null) {
            this.queryDefinitionDao.delete(queryDefinition);
        }
    }

    @CachePut(value={"rsqSqlDefCache"}, key="#toUpdate.queryId")
    public QueryDefinition save(QueryDefinition toUpdate) {
        return (QueryDefinition)this.queryDefinitionDao.save(toUpdate);
    }

    @Cacheable(value={"rsqSqlDefCache"}, key="#queryId", unless="#result == null")
    public QueryDefinition findByQueryId(String queryId) {
        return this.queryDefinitionDao.findByQueryId(queryId);
    }
}

