/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.service;

import cn.patterncat.rsq.dao.pg.LoginTokenDao;
import cn.patterncat.rsq.domain.pg.LoginToken;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class O00000o0 {
    @Autowired
    LoginTokenDao loginTokenDao;

    @CacheEvict(value={"rsqTokenCache"}, key="#accessToken")
    public void delete(String accessToken) {
        this.loginTokenDao.cancelToken(accessToken);
    }

    @CachePut(value={"rsqTokenCache"}, key="#accessToken")
    public LoginToken saveToken(String loginId, String accessToken) {
        LoginToken loginToken = LoginToken.builder().loginId(loginId).accessToken(accessToken).expireTime(LocalDateTime.now().plusWeeks(1L)).build();
        return (LoginToken)this.loginTokenDao.save(loginToken);
    }

    @Cacheable(value={"rsqTokenCache"}, key="#accessToken", unless="#result == null")
    public LoginToken find(String accessToken) {
        return this.loginTokenDao.findFirstByAccessTokenOrderByCreatedDateDesc(accessToken);
    }
}

