/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.model;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public enum SqlDialect {
    ORACLE11("ORACLE11g"){

        @Override
        public String assembleLimitSql(String sql, Pageable pageable) {
            return String.format("select * from ( select row_.*, rownum rownum_ from ( %s ) row_ where rownum <= %d) where rownum_ > %d", sql, pageable.next().getOffset(), pageable.getOffset());
        }

        @Override
        public String getNullHandlingClause(Sort.NullHandling nullHandling) {
            return this.getDefaultNullHandlingClause(nullHandling);
        }
    }
    ,
    POSTGRES95("POSTGRES95"){

        @Override
        public String assembleLimitSql(String sql, Pageable pageable) {
            return String.format("%s limit %d offset %d ", sql, pageable.getPageSize(), pageable.getOffset());
        }

        @Override
        public String getNullHandlingClause(Sort.NullHandling nullHandling) {
            return this.getDefaultNullHandlingClause(nullHandling);
        }
    };

    String name;

    private SqlDialect(String name) {
        this.name = name;
    }

    public abstract String assembleLimitSql(String var1, Pageable var2);

    public abstract String getNullHandlingClause(Sort.NullHandling var1);

    String getDefaultNullHandlingClause(Sort.NullHandling nullHandling) {
        if (Sort.NullHandling.NULLS_LAST == nullHandling) {
            return " nulls last";
        }
        if (Sort.NullHandling.NULLS_FIRST == nullHandling) {
            return " nulls first";
        }
        return " ";
    }
}

