/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.model;

import java.io.Serializable;
import org.springframework.data.domain.Sort;

public class SortOrder
implements Serializable {
    private Sort.Direction direction;
    private String property;
    private boolean ignoreCase;
    private Sort.NullHandling nullHandling;

    public SortOrder() {
    }

    public static SortOrder from(Sort.Order order) {
        SortOrder sortOrder = SortOrder.builder().direction(order.getDirection()).property(order.getProperty()).ignoreCase(order.isIgnoreCase()).nullHandling(order.getNullHandling()).build();
        return sortOrder;
    }

    public Sort.Order toJpaOrder() {
        Sort.Order order = new Sort.Order(this.direction, this.property, this.nullHandling);
        if (this.ignoreCase) {
            return order.ignoreCase();
        }
        return order;
    }

    private static Sort.Direction $default$direction() {
        return Sort.DEFAULT_DIRECTION;
    }

    private static Sort.NullHandling $default$nullHandling() {
        return Sort.NullHandling.NATIVE;
    }

    SortOrder(Sort.Direction direction, String property, boolean ignoreCase, Sort.NullHandling nullHandling) {
        this.direction = direction;
        this.property = property;
        this.ignoreCase = ignoreCase;
        this.nullHandling = nullHandling;
    }

    public static SortOrderBuilder builder() {
        return new SortOrderBuilder();
    }

    public Sort.Direction getDirection() {
        return this.direction;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Sort.NullHandling getNullHandling() {
        return this.nullHandling;
    }

    public void setDirection(Sort.Direction direction) {
        this.direction = direction;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setNullHandling(Sort.NullHandling nullHandling) {
        this.nullHandling = nullHandling;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortOrder)) {
            return false;
        }
        SortOrder sortOrder = (SortOrder)o;
        if (!sortOrder.canEqual(this)) {
            return false;
        }
        Sort.Direction direction = this.getDirection();
        Sort.Direction direction2 = sortOrder.getDirection();
        if (direction == null ? direction2 != null : !direction.equals(direction2)) {
            return false;
        }
        String string = this.getProperty();
        String string2 = sortOrder.getProperty();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        if (this.isIgnoreCase() != sortOrder.isIgnoreCase()) {
            return false;
        }
        Sort.NullHandling nullHandling = this.getNullHandling();
        Sort.NullHandling nullHandling2 = sortOrder.getNullHandling();
        return !(nullHandling == null ? nullHandling2 != null : !nullHandling.equals(nullHandling2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortOrder;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Sort.Direction direction = this.getDirection();
        n2 = n2 * 59 + (direction == null ? 43 : direction.hashCode());
        String string = this.getProperty();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        n2 = n2 * 59 + (this.isIgnoreCase() ? 79 : 97);
        Sort.NullHandling nullHandling = this.getNullHandling();
        n2 = n2 * 59 + (nullHandling == null ? 43 : nullHandling.hashCode());
        return n2;
    }

    public String toString() {
        return "SortOrder(direction=" + this.getDirection() + ", property=" + this.getProperty() + ", ignoreCase=" + this.isIgnoreCase() + ", nullHandling=" + this.getNullHandling() + ")";
    }

    public static class SortOrderBuilder {
        private boolean direction$set;
        private Sort.Direction direction;
        private String property;
        private boolean ignoreCase;
        private boolean nullHandling$set;
        private Sort.NullHandling nullHandling;

        SortOrderBuilder() {
        }

        public SortOrderBuilder direction(Sort.Direction direction) {
            this.direction = direction;
            this.direction$set = true;
            return this;
        }

        public SortOrderBuilder property(String property) {
            this.property = property;
            return this;
        }

        public SortOrderBuilder ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public SortOrderBuilder nullHandling(Sort.NullHandling nullHandling) {
            this.nullHandling = nullHandling;
            this.nullHandling$set = true;
            return this;
        }

        public SortOrder build() {
            Sort.Direction direction = this.direction;
            if (!this.direction$set) {
                direction = SortOrder.$default$direction();
            }
            Sort.NullHandling nullHandling = this.nullHandling;
            if (!this.nullHandling$set) {
                nullHandling = SortOrder.$default$nullHandling();
            }
            return new SortOrder(direction, this.property, this.ignoreCase, nullHandling);
        }

        public String toString() {
            return "SortOrder.SortOrderBuilder(direction=" + this.direction + ", property=" + this.property + ", ignoreCase=" + this.ignoreCase + ", nullHandling=" + this.nullHandling + ")";
        }
    }
}

