/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.model;

import cn.patterncat.rsq.model.ColumnSqlType;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

public enum ColumnJavaType {
    BOOLEAN((Class)Boolean.class){

        @Override
        public Object toJavaType(String value) {
            return Boolean.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.BIT == jdbcType;
        }
    }
    ,
    BYTE((Class)Byte.class){

        @Override
        public Object toJavaType(String value) {
            return Byte.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.TINYINT == jdbcType;
        }
    }
    ,
    SHORT((Class)Short.class){

        @Override
        public Object toJavaType(String value) {
            return Short.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.SMALLINT == jdbcType;
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public Object toJavaType(String value) {
            return Integer.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.INTEGER == jdbcType;
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public Object toJavaType(String value) {
            return Long.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.BIGINT == jdbcType;
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public Object toJavaType(String value) {
            return Float.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.REAL == jdbcType || ColumnSqlType.FLOAT == jdbcType;
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public Object toJavaType(String value) {
            return Double.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.DOUBLE == jdbcType;
        }
    }
    ,
    DECIMAL((Class)BigDecimal.class){

        @Override
        public Object toJavaType(String value) {
            return new BigDecimal(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.NUMERIC == jdbcType || ColumnSqlType.DECIMAL == jdbcType;
        }
    }
    ,
    BYTE_ARRAY((Class)Byte[].class){

        @Override
        public Object toJavaType(String value) {
            return value.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.BINARY == jdbcType || ColumnSqlType.VARBINARY == jdbcType || ColumnSqlType.LONGVARBINARY == jdbcType;
        }
    }
    ,
    DATE((Class)Date.class){

        @Override
        public Object toJavaType(String value) {
            return Date.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.DATE == jdbcType;
        }
    }
    ,
    TIME((Class)Time.class){

        @Override
        public Object toJavaType(String value) {
            return Time.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.TIME == jdbcType;
        }
    }
    ,
    TIME_STAMP((Class)Timestamp.class){

        @Override
        public Object toJavaType(String value) {
            return Timestamp.valueOf(value);
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.TIMESTAMP == jdbcType;
        }
    }
    ,
    STRING((Class)String.class){

        @Override
        public Object toJavaType(String value) {
            return value;
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return ColumnSqlType.CHAR == jdbcType || ColumnSqlType.VARCHAR == jdbcType || ColumnSqlType.LONGVARCHAR == jdbcType;
        }
    }
    ,
    OBJECT((Class)Object.class){

        @Override
        public Object toJavaType(String value) {
            return value;
        }

        @Override
        public boolean match(ColumnSqlType jdbcType) {
            return true;
        }
    };

    Class<?> javaType;

    private ColumnJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public abstract Object toJavaType(String var1);

    public abstract boolean match(ColumnSqlType var1);

    public static ColumnJavaType getMatchType(ColumnSqlType jdbcType) {
        return Arrays.stream(ColumnJavaType.values()).filter(type -> type.match(jdbcType)).findFirst().get();
    }
}

