/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.controller;

import cn.patterncat.rsq.service.YamlExportService;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/rsq-export"})
public class YamlExportController {
    @Value(value="${rsq.download.token:restsql}")
    String realToken;
    @Autowired
    YamlExportService yamlExportService;

    @GetMapping(value={""})
    public void downloadYaml(@RequestParam(value="downloadToken") String downloadToken, HttpServletResponse response) throws IOException {
        if (!this.realToken.equals(downloadToken)) {
            response.sendError(403);
        }
        response.setContentType("text/plain");
        response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        response.setHeader("Content-Disposition", "inline");
        String string = this.yamlExportService.exportYamlAsString().replaceAll("\\\\", " ");
        StreamUtils.copy((String)string, (Charset)StandardCharsets.UTF_8, (OutputStream)response.getOutputStream());
    }
}

