/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.controller;

import cn.patterncat.rest.ApiResult;
import cn.patterncat.rsq.domain.pg.QueryDefinition;
import cn.patterncat.rsq.service.YamlImportService;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rsq-deploy"})
public class YamlDeployController {
    @Value(value="${rsq.deploy.token:restsql}")
    String realToken;
    @Autowired
    YamlImportService yamlImportService;

    @PostMapping
    public ApiResult upload(@RequestParam(value="file", required=true) MultipartFile multipartFile, @RequestParam(value="deployToken") String deployToken) throws IOException {
        if (!this.realToken.equals(deployToken)) {
            return ApiResult.fail((String)"invalid deploy token");
        }
        String string = Files.getFileExtension((String)multipartFile.getOriginalFilename());
        File file = File.createTempFile("tmp-", "-zip");
        multipartFile.transferTo(file);
        if ("yaml".equals(string) || "yml".equals(string)) {
            List<QueryDefinition> list = this.yamlImportService.parseYamlAndUpdateOrCreate(file);
            return ApiResult.success(list);
        }
        if ("zip".equals(string)) {
            List<QueryDefinition> list = this.yamlImportService.parseZipAndUpdateOrCreate(file);
            return ApiResult.success(list);
        }
        return ApiResult.fail((String)"unsupported file type");
    }
}

