/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.controller;

import cn.patterncat.rest.ApiResult;
import cn.patterncat.rsq.a.O00000o;
import cn.patterncat.rsq.component.security.a.O000000o;
import cn.patterncat.rsq.component.security.a.O00000o0;
import cn.patterncat.rsq.domain.pg.UserAccount;
import cn.patterncat.rsq.service.O0000O0o;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.WebUtils;

@RestController
@RequestMapping(value={"/rsq-user"})
public class UserController {
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    O0000O0o userService;
    @Autowired
    cn.patterncat.rsq.service.O00000o0 tokenService;

    @PostMapping(value={"/login"})
    public ApiResult login(@RequestBody UserAccount account, HttpServletResponse response) {
        UserAccount userAccount = this.userService.findByLoginId(account.getLoginId());
        if (userAccount == null) {
            return ApiResult.fail((String)"user or password not correct");
        }
        if (userAccount.isLocked()) {
            return ApiResult.fail((String)"account is locked");
        }
        boolean bl = this.passwordEncoder.matches((CharSequence)account.getPassword(), userAccount.getPassword());
        if (!bl) {
            return ApiResult.fail((String)"user or password not correct");
        }
        userAccount.traceLogin();
        this.userService.save(userAccount);
        String string = UUID.randomUUID().toString();
        this.tokenService.saveToken(userAccount.getLoginId(), string);
        O00000o.a("rqlToken", string, 604800, response);
        return ApiResult.success((Object)string);
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET, RequestMethod.POST})
    public ApiResult logout(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)"rqlToken");
        if (cookie != null) {
            this.tokenService.delete(cookie.getValue());
        }
        O00000o.a("rqlToken", null, 0, response);
        return ApiResult.success();
    }

    @PostMapping(value={""})
    @O000000o(c=O00000o0.ADMIN)
    public ApiResult createUser(@RequestBody UserAccount userAccount) {
        userAccount.setPassword(this.passwordEncoder.encode((CharSequence)userAccount.getPassword()));
        return ApiResult.success((Object)this.userService.save(userAccount));
    }

    @DeleteMapping(value={"/{loginId}"})
    @O000000o(c=O00000o0.ADMIN)
    public ApiResult deleteUser(@PathVariable String loginId) {
        this.userService.delete(loginId);
        return ApiResult.success();
    }
}

