/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.controller;

import cn.patterncat.helper.sql.builder.JpaSpecBuilder;
import cn.patterncat.rest.ApiResult;
import cn.patterncat.rsq.component.security.a.O000000o;
import cn.patterncat.rsq.component.security.a.O00000o0;
import cn.patterncat.rsq.domain.pg.QueryDefinition;
import cn.patterncat.rsq.service.QueryDefinitionService;
import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rsq-query-definition"})
public class QueryDefinitionController {
    @Autowired
    QueryDefinitionService queryDefinitionService;

    @GetMapping(value={"/{queryId}"})
    @O000000o(c=O00000o0.USER)
    public ApiResult<QueryDefinition> getByQueryId(@PathVariable String queryId) {
        QueryDefinition queryDefinition = this.queryDefinitionService.findByQueryId(queryId);
        return ApiResult.success((Object)queryDefinition);
    }

    @PostMapping(value={""})
    @O000000o(c=O00000o0.ADMIN)
    public ApiResult createQueryDefinition(@RequestBody QueryDefinition queryDefinition) {
        return ApiResult.success((Object)this.queryDefinitionService.save(queryDefinition));
    }

    @DeleteMapping(value={"/{queryId}"})
    @O000000o(c=O00000o0.ADMIN)
    public ApiResult deleteQueryDefinition(@PathVariable String queryId) {
        this.queryDefinitionService.delete(queryId);
        return ApiResult.success();
    }

    @PostMapping(value={"/{queryId}"})
    @O000000o(c=O00000o0.ADMIN)
    public ApiResult updateQueryDefinitioin(@PathVariable String queryId, @RequestBody QueryDefinition queryDefinition) {
        QueryDefinition queryDefinition2 = this.queryDefinitionService.findByQueryId(queryId);
        queryDefinition2.setDataSource(queryDefinition.getDataSource());
        queryDefinition2.setSortOrders(queryDefinition.getSortOrders());
        queryDefinition2.setQueryParams(queryDefinition.getQueryParams());
        queryDefinition2.setSql(queryDefinition.getSql());
        return ApiResult.success((Object)this.queryDefinitionService.save(queryDefinition2));
    }

    @GetMapping(value={"/list"})
    @O000000o(c=O00000o0.USER)
    public ApiResult<Page<QueryDefinition>> list(@RequestParam(required=false) String queryId, @RequestParam(required=false) String namespace, @PageableDefault(page=0, size=20, sort={"createdDate"}, direction=Sort.Direction.DESC) Pageable pageable) {
        JpaSpecBuilder jpaSpecBuilder = JpaSpecBuilder.newInstance();
        if (StringUtils.isNotBlank((CharSequence)queryId)) {
            jpaSpecBuilder.and((Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("queryId"), (Object)queryId));
        }
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            jpaSpecBuilder.and((Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("namespace"), (Object)namespace));
        }
        return ApiResult.success(this.queryDefinitionService.findAll((Specification<QueryDefinition>)jpaSpecBuilder.build(), pageable));
    }
}

