/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.config;

import java.util.HashMap;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnProperty(name={"rsq.def.jpa.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@EnableJpaRepositories(basePackages={"cn.patterncat.rsq.dao.pg"}, entityManagerFactoryRef="pgEntityManagerFactory", transactionManagerRef="pgTransactionManager")
public class PgDataConfig {
    @Bean(value={"pgPoolProperties"})
    @Primary
    @ConfigurationProperties(prefix="spring.datasource.pg")
    public PoolProperties pgPoolProperties() {
        return new PoolProperties();
    }

    @Bean(value={"pgDataSource"})
    @Primary
    public javax.sql.DataSource pgDataSource(@Qualifier(value="pgPoolProperties") PoolProperties pgPoolProperties) {
        DataSource dataSource = new DataSource((PoolConfiguration)pgPoolProperties);
        return dataSource;
    }

    @Bean
    @Qualifier(value="pgTransactionManager")
    PlatformTransactionManager pgTransactionManager(@Qualifier(value="pgDataSource") javax.sql.DataSource pgDataSource) {
        return new JpaTransactionManager(this.pgEntityManagerFactory(pgDataSource).getObject());
    }

    @Bean
    @Primary
    LocalContainerEntityManagerFactoryBean pgEntityManagerFactory(@Qualifier(value="pgDataSource") javax.sql.DataSource pgDataSource) {
        HibernateJpaVendorAdapter hibernateJpaVendorAdapter = new HibernateJpaVendorAdapter();
        hibernateJpaVendorAdapter.setGenerateDdl(true);
        hibernateJpaVendorAdapter.setDatabase(Database.POSTGRESQL);
        hibernateJpaVendorAdapter.setDatabasePlatform("org.hibernate.dialect.PostgreSQLDialect");
        LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        localContainerEntityManagerFactoryBean.setDataSource(pgDataSource);
        localContainerEntityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)hibernateJpaVendorAdapter);
        localContainerEntityManagerFactoryBean.setPackagesToScan(new String[]{"cn.patterncat.rsq.domain.pg"});
        localContainerEntityManagerFactoryBean.setPersistenceUnitName("pgPersistUnit");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("hibernate.physical_naming_strategy", new SpringPhysicalNamingStrategy());
        hashMap.put("hibernate.ejb.entitymanager_factory_name", "pgEntityManagerFactory");
        hashMap.put("hibernate.hbm2ddl.auto", "update");
        localContainerEntityManagerFactoryBean.setJpaPropertyMap(hashMap);
        return localContainerEntityManagerFactoryBean;
    }
}

