/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.dialect.OracleSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.tools.Frameworks;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.vendor.Database;

@Configuration
public class CalciteConfig {
    @Autowired
    @Qualifier(value="rsqDataSource")
    DataSource dataSource;
    @Value(value="${spring.datasource.rsq.username}")
    String rqlUserName;
    @Value(value="${spring.datasource.rsq.databaseType}")
    Database databaseType;
    public static final String[] REPLACED = new String[]{null};

    @Bean
    public RelDataTypeFactory relDataTypeFactory() {
        RelDataTypeSystem relDataTypeSystem;
        if (Database.ORACLE == this.databaseType) {
            relDataTypeSystem = OracleSqlDialect.DEFAULT.getTypeSystem();
        } else if (Database.POSTGRESQL == this.databaseType) {
            relDataTypeSystem = PostgresqlSqlDialect.DEFAULT.getTypeSystem();
        } else {
            throw new IllegalArgumentException("only postgres and oracle are supported now");
        }
        return new SqlTypeFactoryImpl(relDataTypeSystem);
    }

    @Bean
    public Prepare.CatalogReader catalogReader(RelDataTypeFactory typeFactory) throws ClassNotFoundException, SQLException {
        String string;
        SchemaPlus schemaPlus = Frameworks.createRootSchema((boolean)false);
        Connection connection = this.dataSource.getConnection();
        String string2 = connection.getCatalog();
        try {
            string = connection.getSchema();
        }
        catch (Throwable throwable) {
            string = this.rqlUserName;
        }
        connection.close();
        JdbcSchema jdbcSchema = JdbcSchema.create((SchemaPlus)schemaPlus, (String)string, (DataSource)this.dataSource, (String)string2, (String)string);
        schemaPlus.add(string, (Schema)jdbcSchema);
        CalciteConnectionConfigImpl calciteConnectionConfigImpl = new CalciteConnectionConfigImpl(new Properties());
        calciteConnectionConfigImpl.set(CalciteConnectionProperty.CASE_SENSITIVE, "true");
        return new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)schemaPlus), Arrays.asList(string), typeFactory, (CalciteConnectionConfig)calciteConnectionConfigImpl);
    }

    @Bean
    public SqlValidatorWithHints sqlValidatorWithHints(Prepare.CatalogReader catalogReader, RelDataTypeFactory typeFactory) {
        return SqlValidatorUtil.newValidator((SqlOperatorTable)SqlStdOperatorTable.instance(), (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)typeFactory, (SqlConformance)SqlConformanceEnum.DEFAULT);
    }

    @Bean
    public SqlAdvisor sqlAdvisor(SqlValidatorWithHints sqlValidatorWithHints) {
        SqlParser.Config config = SqlParser.configBuilder().setCaseSensitive(true).setUnquotedCasing(Casing.UNCHANGED).build();
        return new SqlAdvisor(sqlValidatorWithHints, config);
    }
}

