/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import cn.patterncat.rsq.model.SqlDialect;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.JpaSort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SortUtil {
    public static final Pattern ORDER_BY = Pattern.compile(".*order\\s+by\\s+.*", 2);
    public static final Pattern PUNCTATION_PATTERN = Pattern.compile(".*((?![\\._])[\\p{Punct}|\\s])");
    public static final String UNSAFE_PROPERTY_REFERENCE = "Sort expression '%s' must only contain property references or aliases used in the select clause. If you really want to use something other than that for sorting, please use JpaSort.unsafe(\u2026)!";

    public static String applySorting(String query, Sort sort, SqlDialect sqlDialect) {
        String string = QueryUtils.detectAlias((String)query);
        Assert.hasText((String)query, (String)"Query must not be null or empty!");
        if (sort.isUnsorted()) {
            return query;
        }
        StringBuilder stringBuilder = new StringBuilder(query);
        if (!ORDER_BY.matcher(query).matches()) {
            stringBuilder.append(" order by ");
        } else {
            stringBuilder.append(", ");
        }
        Set set = QueryUtils.getOuterJoinAliases((String)query);
        Set set2 = QueryUtils.getFunctionAliases((String)query);
        for (Sort.Order order : sort) {
            stringBuilder.append(SortUtil.getOrderClause(set, set2, string, order));
            stringBuilder.append(sqlDialect.getNullHandlingClause(order.getNullHandling()));
            stringBuilder.append(", ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    private static String getOrderClause(Set<String> joinAliases, Set<String> functionAlias, @Nullable String alias, Sort.Order order) {
        String string = order.getProperty();
        SortUtil.checkSortExpression(order);
        if (functionAlias.contains(string)) {
            return String.format("%s %s", string, SortUtil.toJpaDirection(order));
        }
        boolean bl = !string.contains("(");
        for (String object2 : joinAliases) {
            if (!string.startsWith(object2.concat("."))) continue;
            bl = false;
            break;
        }
        String string2 = bl && StringUtils.hasText((String)alias) ? String.format("%s.%s", alias, string) : string;
        Object object = order.isIgnoreCase() ? String.format("lower(%s)", string2) : string2;
        return String.format("%s %s", object, SortUtil.toJpaDirection(order));
    }

    private static void checkSortExpression(Sort.Order order) {
        if (order instanceof JpaSort.JpaOrder && ((JpaSort.JpaOrder)order).isUnsafe()) {
            return;
        }
        if (PUNCTATION_PATTERN.matcher(order.getProperty()).find()) {
            throw new InvalidDataAccessApiUsageException(String.format(UNSAFE_PROPERTY_REFERENCE, order));
        }
    }

    private static String toJpaDirection(Sort.Order order) {
        return order.getDirection().name().toLowerCase(Locale.US);
    }

    private static String toNullsSort(Sort.Order order) {
        return order.getNullHandling().name().toLowerCase(Locale.US);
    }
}

