/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.service;

import cn.patterncat.rsq.a.O0000O0o;
import cn.patterncat.rsq.dao.pg.QueryDefinitionDao;
import cn.patterncat.rsq.domain.pg.QueryDefinition;
import cn.patterncat.rsq.model.QueryAuthInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class YamlImportService {
    ObjectMapper yamlObjectMapper;
    YAMLFactory yamlFactory = new YAMLFactory();
    @Autowired
    QueryDefinitionDao queryDefinitionDao;
    @Autowired
    List<QueryAuthInfo> defaultAuthInfos;

    public YamlImportService() {
        this.yamlObjectMapper = new ObjectMapper((JsonFactory)this.yamlFactory);
        this.yamlObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public List<QueryDefinition> parseYamlAndUpdateOrCreate(File yamlFile) throws IOException {
        List<QueryDefinition> list = this.parseYaml(yamlFile);
        return this.updateOrCreate(list);
    }

    public List<QueryDefinition> parseYaml(File yamlFile) throws IOException {
        YAMLParser yAMLParser = this.yamlFactory.createParser(yamlFile);
        List list = this.yamlObjectMapper.readValues((JsonParser)yAMLParser, (TypeReference)new TypeReference<QueryDefinition>(){}).readAll();
        list.stream().forEach(e -> this.validateInput((QueryDefinition)e));
        return list;
    }

    public void validateInput(QueryDefinition definition) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)definition.getQueryId()));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)definition.getSql()));
        Preconditions.checkArgument((definition.getSqlDialect() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((definition.getQueryType() != null ? 1 : 0) != 0);
        if (definition.getQueryParams() == null) {
            definition.setQueryParams(Collections.emptyList());
        }
        definition.getQueryParams().stream().forEach(e -> {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)e.getName()));
            Preconditions.checkArgument((e.getColumnSqlType() != null ? 1 : 0) != 0);
        });
        if (definition.getSortOrders() == null) {
            definition.setSortOrders(Collections.emptyList());
        }
        definition.getSortOrders().stream().forEach(e -> {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)e.getProperty()));
            Preconditions.checkArgument((e.getDirection() != null ? 1 : 0) != 0);
            if (e.getNullHandling() == null) {
                e.setNullHandling(Sort.NullHandling.NATIVE);
            }
        });
    }

    public List<QueryDefinition> updateOrCreate(List<QueryDefinition> definitions) {
        return definitions.stream().map(e -> {
            QueryDefinition queryDefinition = this.queryDefinitionDao.findByQueryId(e.getQueryId());
            if (queryDefinition == null) {
                queryDefinition = QueryDefinition.builder().queryId(e.getQueryId()).build();
            }
            queryDefinition.setSql(e.getSql());
            queryDefinition.setQueryParams(e.getQueryParams());
            queryDefinition.setSortOrders(e.getSortOrders());
            queryDefinition.setPaged(e.isPaged());
            queryDefinition.setSqlDialect(e.getSqlDialect());
            queryDefinition.setQueryType(e.getQueryType());
            if (CollectionUtils.isEmpty(e.getAuthInfos())) {
                queryDefinition.setAuthInfos(this.defaultAuthInfos);
            } else {
                queryDefinition.setAuthInfos(e.getAuthInfos());
            }
            queryDefinition.setDemoUrl(e.getDemoUrl());
            queryDefinition.setNote(e.getNote());
            return (QueryDefinition)this.queryDefinitionDao.save(queryDefinition);
        }).collect(Collectors.toList());
    }

    public List<QueryDefinition> parseZipAndUpdateOrCreate(File zipFile) throws IOException {
        List<QueryDefinition> list = this.parseYamlZip(zipFile);
        return this.updateOrCreate(list);
    }

    public List<QueryDefinition> parseYamlZip(File zipFile) throws IOException {
        File file = Files.createTempDir();
        O0000O0o.b(zipFile, file);
        ArrayList<QueryDefinition> arrayList = new ArrayList<QueryDefinition>();
        this.traverseFile(file, arrayList);
        return arrayList;
    }

    public void traverseFile(File node, List<QueryDefinition> collector) throws IOException {
        if (node.isDirectory()) {
            String[] stringArray;
            for (String string : stringArray = node.list()) {
                this.traverseFile(new File(node, string), collector);
            }
        } else {
            collector.addAll(this.parseYaml(node));
        }
    }
}

