/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.domain.pg;

import cn.patterncat.rsq.component.security.a.O00000o0;
import cn.patterncat.rsq.domain.PgAuditableEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotBlank;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Entity
@Table(name="rsq_user_account", uniqueConstraints={@UniqueConstraint(name="login_id_idx", columnNames={"loginId"})})
@Where(clause="deleted is false")
public class UserAccount
extends PgAuditableEntity {
    public static final List<String> DEFAULT_ROLES = new ArrayList<String>(){
        {
            this.add(O00000o0.USER.name());
        }
    };
    @NotBlank
    private String name;
    @NotBlank
    private String loginId;
    @Column(length=60)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @NotBlank
    private String password;
    private int loginCount;
    private Date lastLoginDate;
    private boolean locked;
    @Type(type="jsonb")
    @Column(columnDefinition="json")
    private List<String> roles;

    public UserAccount() {
    }

    public void traceLogin() {
        ++this.loginCount;
        this.lastLoginDate = new Date();
    }

    private static int $default$loginCount() {
        return 0;
    }

    private static boolean $default$locked() {
        return false;
    }

    private static List<String> $default$roles() {
        return DEFAULT_ROLES;
    }

    UserAccount(String name, String loginId, String password, int loginCount, Date lastLoginDate, boolean locked, List<String> roles) {
        this.name = name;
        this.loginId = loginId;
        this.password = password;
        this.loginCount = loginCount;
        this.lastLoginDate = lastLoginDate;
        this.locked = locked;
        this.roles = roles;
    }

    public static UserAccountBuilder builder() {
        return new UserAccountBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public String getPassword() {
        return this.password;
    }

    public int getLoginCount() {
        return this.loginCount;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLoginCount(int loginCount) {
        this.loginCount = loginCount;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserAccount)) {
            return false;
        }
        UserAccount userAccount = (UserAccount)o;
        if (!userAccount.canEqual(this)) {
            return false;
        }
        String string = this.getName();
        String string2 = userAccount.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getLoginId();
        String string4 = userAccount.getLoginId();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getPassword();
        String string6 = userAccount.getPassword();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        if (this.getLoginCount() != userAccount.getLoginCount()) {
            return false;
        }
        Date date = this.getLastLoginDate();
        Date date2 = userAccount.getLastLoginDate();
        if (date == null ? date2 != null : !((Object)date).equals(date2)) {
            return false;
        }
        if (this.isLocked() != userAccount.isLocked()) {
            return false;
        }
        List<String> list = this.getRoles();
        List<String> list2 = userAccount.getRoles();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserAccount;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getLoginId();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getPassword();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        n2 = n2 * 59 + this.getLoginCount();
        Date date = this.getLastLoginDate();
        n2 = n2 * 59 + (date == null ? 43 : ((Object)date).hashCode());
        n2 = n2 * 59 + (this.isLocked() ? 79 : 97);
        List<String> list = this.getRoles();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "UserAccount(name=" + this.getName() + ", loginId=" + this.getLoginId() + ", password=" + this.getPassword() + ", loginCount=" + this.getLoginCount() + ", lastLoginDate=" + this.getLastLoginDate() + ", locked=" + this.isLocked() + ", roles=" + this.getRoles() + ")";
    }

    public static class UserAccountBuilder {
        private String name;
        private String loginId;
        private String password;
        private boolean loginCount$set;
        private int loginCount;
        private Date lastLoginDate;
        private boolean locked$set;
        private boolean locked;
        private boolean roles$set;
        private List<String> roles;

        UserAccountBuilder() {
        }

        public UserAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserAccountBuilder loginId(String loginId) {
            this.loginId = loginId;
            return this;
        }

        public UserAccountBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserAccountBuilder loginCount(int loginCount) {
            this.loginCount = loginCount;
            this.loginCount$set = true;
            return this;
        }

        public UserAccountBuilder lastLoginDate(Date lastLoginDate) {
            this.lastLoginDate = lastLoginDate;
            return this;
        }

        public UserAccountBuilder locked(boolean locked) {
            this.locked = locked;
            this.locked$set = true;
            return this;
        }

        public UserAccountBuilder roles(List<String> roles) {
            this.roles = roles;
            this.roles$set = true;
            return this;
        }

        public UserAccount build() {
            int n = this.loginCount;
            if (!this.loginCount$set) {
                n = UserAccount.$default$loginCount();
            }
            boolean bl = this.locked;
            if (!this.locked$set) {
                bl = UserAccount.$default$locked();
            }
            List<String> list = this.roles;
            if (!this.roles$set) {
                list = UserAccount.$default$roles();
            }
            return new UserAccount(this.name, this.loginId, this.password, n, this.lastLoginDate, bl, list);
        }

        public String toString() {
            return "UserAccount.UserAccountBuilder(name=" + this.name + ", loginId=" + this.loginId + ", password=" + this.password + ", loginCount=" + this.loginCount + ", lastLoginDate=" + this.lastLoginDate + ", locked=" + this.locked + ", roles=" + this.roles + ")";
        }
    }
}

