/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.domain.pg;

import cn.patterncat.rsq.domain.PgAuditableEntity;
import cn.patterncat.rsq.model.QueryAuthInfo;
import cn.patterncat.rsq.model.QueryParam;
import cn.patterncat.rsq.model.QueryType;
import cn.patterncat.rsq.model.SortOrder;
import cn.patterncat.rsq.model.SqlDialect;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Type;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.SortUtil;

@Entity
@Table(name="rsq_query_definition", uniqueConstraints={@UniqueConstraint(name="query_definition_idx", columnNames={"queryId"})})
public class QueryDefinition
extends PgAuditableEntity {
    private String queryId;
    private String namespace;
    private String dataSource;
    @Column(columnDefinition="text")
    private String sql;
    @Enumerated(value=EnumType.STRING)
    private SqlDialect sqlDialect;
    @Type(type="jsonb")
    @Column(columnDefinition="json")
    private List<QueryParam> queryParams;
    @Type(type="jsonb")
    @Column(columnDefinition="json")
    private List<SortOrder> sortOrders;
    @Type(type="jsonb")
    @Column(columnDefinition="json")
    private List<QueryAuthInfo> authInfos;
    @Enumerated(value=EnumType.STRING)
    private QueryType queryType;
    private boolean paged;
    private String demoUrl;
    private String note;

    public QueryDefinition() {
    }

    public String generateSortSql(String sqlToUse, Sort sort) {
        if (sort != null) {
            return SortUtil.applySorting(sqlToUse, sort, this.sqlDialect);
        }
        if (this.sortOrders == null || this.sortOrders.isEmpty()) {
            return sqlToUse;
        }
        List list = this.sortOrders.stream().map(o -> o.toJpaOrder()).collect(Collectors.toList());
        return SortUtil.applySorting(sqlToUse, Sort.by(list), this.sqlDialect);
    }

    private static List<QueryParam> $default$queryParams() {
        return new ArrayList<QueryParam>();
    }

    private static List<SortOrder> $default$sortOrders() {
        return new ArrayList<SortOrder>();
    }

    private static List<QueryAuthInfo> $default$authInfos() {
        return new ArrayList<QueryAuthInfo>();
    }

    private static boolean $default$paged() {
        return false;
    }

    QueryDefinition(String queryId, String namespace, String dataSource, String sql, SqlDialect sqlDialect, List<QueryParam> queryParams, List<SortOrder> sortOrders, List<QueryAuthInfo> authInfos, QueryType queryType, boolean paged, String demoUrl, String note) {
        this.queryId = queryId;
        this.namespace = namespace;
        this.dataSource = dataSource;
        this.sql = sql;
        this.sqlDialect = sqlDialect;
        this.queryParams = queryParams;
        this.sortOrders = sortOrders;
        this.authInfos = authInfos;
        this.queryType = queryType;
        this.paged = paged;
        this.demoUrl = demoUrl;
        this.note = note;
    }

    public static QueryDefinitionBuilder builder() {
        return new QueryDefinitionBuilder();
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public List<QueryParam> getQueryParams() {
        return this.queryParams;
    }

    public List<SortOrder> getSortOrders() {
        return this.sortOrders;
    }

    public List<QueryAuthInfo> getAuthInfos() {
        return this.authInfos;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public boolean isPaged() {
        return this.paged;
    }

    public String getDemoUrl() {
        return this.demoUrl;
    }

    public String getNote() {
        return this.note;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setSqlDialect(SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public void setQueryParams(List<QueryParam> queryParams) {
        this.queryParams = queryParams;
    }

    public void setSortOrders(List<SortOrder> sortOrders) {
        this.sortOrders = sortOrders;
    }

    public void setAuthInfos(List<QueryAuthInfo> authInfos) {
        this.authInfos = authInfos;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public void setPaged(boolean paged) {
        this.paged = paged;
    }

    public void setDemoUrl(String demoUrl) {
        this.demoUrl = demoUrl;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryDefinition)) {
            return false;
        }
        QueryDefinition queryDefinition = (QueryDefinition)o;
        if (!queryDefinition.canEqual(this)) {
            return false;
        }
        String string = this.getQueryId();
        String string2 = queryDefinition.getQueryId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getNamespace();
        String string4 = queryDefinition.getNamespace();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getDataSource();
        String string6 = queryDefinition.getDataSource();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getSql();
        String string8 = queryDefinition.getSql();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        SqlDialect sqlDialect = this.getSqlDialect();
        SqlDialect sqlDialect2 = queryDefinition.getSqlDialect();
        if (sqlDialect == null ? sqlDialect2 != null : !((Object)((Object)sqlDialect)).equals((Object)sqlDialect2)) {
            return false;
        }
        List<QueryParam> list = this.getQueryParams();
        List<QueryParam> list2 = queryDefinition.getQueryParams();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<SortOrder> list3 = this.getSortOrders();
        List<SortOrder> list4 = queryDefinition.getSortOrders();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        List<QueryAuthInfo> list5 = this.getAuthInfos();
        List<QueryAuthInfo> list6 = queryDefinition.getAuthInfos();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        QueryType queryType = this.getQueryType();
        QueryType queryType2 = queryDefinition.getQueryType();
        if (queryType == null ? queryType2 != null : !((Object)((Object)queryType)).equals((Object)queryType2)) {
            return false;
        }
        if (this.isPaged() != queryDefinition.isPaged()) {
            return false;
        }
        String string9 = this.getDemoUrl();
        String string10 = queryDefinition.getDemoUrl();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        String string11 = this.getNote();
        String string12 = queryDefinition.getNote();
        return !(string11 == null ? string12 != null : !string11.equals(string12));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryDefinition;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        String string = this.getQueryId();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getNamespace();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getDataSource();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getSql();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        SqlDialect sqlDialect = this.getSqlDialect();
        n2 = n2 * 59 + (sqlDialect == null ? 43 : ((Object)((Object)sqlDialect)).hashCode());
        List<QueryParam> list = this.getQueryParams();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<SortOrder> list2 = this.getSortOrders();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        List<QueryAuthInfo> list3 = this.getAuthInfos();
        n2 = n2 * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        QueryType queryType = this.getQueryType();
        n2 = n2 * 59 + (queryType == null ? 43 : ((Object)((Object)queryType)).hashCode());
        n2 = n2 * 59 + (this.isPaged() ? 79 : 97);
        String string5 = this.getDemoUrl();
        n2 = n2 * 59 + (string5 == null ? 43 : string5.hashCode());
        String string6 = this.getNote();
        n2 = n2 * 59 + (string6 == null ? 43 : string6.hashCode());
        return n2;
    }

    public String toString() {
        return "QueryDefinition(queryId=" + this.getQueryId() + ", namespace=" + this.getNamespace() + ", dataSource=" + this.getDataSource() + ", sql=" + this.getSql() + ", sqlDialect=" + this.getSqlDialect() + ", queryParams=" + this.getQueryParams() + ", sortOrders=" + this.getSortOrders() + ", authInfos=" + this.getAuthInfos() + ", queryType=" + this.getQueryType() + ", paged=" + this.isPaged() + ", demoUrl=" + this.getDemoUrl() + ", note=" + this.getNote() + ")";
    }

    public static class QueryDefinitionBuilder {
        private String queryId;
        private String namespace;
        private String dataSource;
        private String sql;
        private SqlDialect sqlDialect;
        private boolean queryParams$set;
        private List<QueryParam> queryParams;
        private boolean sortOrders$set;
        private List<SortOrder> sortOrders;
        private boolean authInfos$set;
        private List<QueryAuthInfo> authInfos;
        private QueryType queryType;
        private boolean paged$set;
        private boolean paged;
        private String demoUrl;
        private String note;

        QueryDefinitionBuilder() {
        }

        public QueryDefinitionBuilder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public QueryDefinitionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryDefinitionBuilder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public QueryDefinitionBuilder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public QueryDefinitionBuilder sqlDialect(SqlDialect sqlDialect) {
            this.sqlDialect = sqlDialect;
            return this;
        }

        public QueryDefinitionBuilder queryParams(List<QueryParam> queryParams) {
            this.queryParams = queryParams;
            this.queryParams$set = true;
            return this;
        }

        public QueryDefinitionBuilder sortOrders(List<SortOrder> sortOrders) {
            this.sortOrders = sortOrders;
            this.sortOrders$set = true;
            return this;
        }

        public QueryDefinitionBuilder authInfos(List<QueryAuthInfo> authInfos) {
            this.authInfos = authInfos;
            this.authInfos$set = true;
            return this;
        }

        public QueryDefinitionBuilder queryType(QueryType queryType) {
            this.queryType = queryType;
            return this;
        }

        public QueryDefinitionBuilder paged(boolean paged) {
            this.paged = paged;
            this.paged$set = true;
            return this;
        }

        public QueryDefinitionBuilder demoUrl(String demoUrl) {
            this.demoUrl = demoUrl;
            return this;
        }

        public QueryDefinitionBuilder note(String note) {
            this.note = note;
            return this;
        }

        public QueryDefinition build() {
            List<QueryParam> list = this.queryParams;
            if (!this.queryParams$set) {
                list = QueryDefinition.$default$queryParams();
            }
            List<SortOrder> list2 = this.sortOrders;
            if (!this.sortOrders$set) {
                list2 = QueryDefinition.$default$sortOrders();
            }
            List<QueryAuthInfo> list3 = this.authInfos;
            if (!this.authInfos$set) {
                list3 = QueryDefinition.$default$authInfos();
            }
            boolean bl = this.paged;
            if (!this.paged$set) {
                bl = QueryDefinition.$default$paged();
            }
            return new QueryDefinition(this.queryId, this.namespace, this.dataSource, this.sql, this.sqlDialect, list, list2, list3, this.queryType, bl, this.demoUrl, this.note);
        }

        public String toString() {
            return "QueryDefinition.QueryDefinitionBuilder(queryId=" + this.queryId + ", namespace=" + this.namespace + ", dataSource=" + this.dataSource + ", sql=" + this.sql + ", sqlDialect=" + this.sqlDialect + ", queryParams=" + this.queryParams + ", sortOrders=" + this.sortOrders + ", authInfos=" + this.authInfos + ", queryType=" + this.queryType + ", paged=" + this.paged + ", demoUrl=" + this.demoUrl + ", note=" + this.note + ")";
        }
    }
}

