/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.domain.pg;

import cn.patterncat.rsq.domain.PgAuditableEntity;
import java.time.LocalDateTime;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Where;

@Entity
@Table(name="rsq_login_token", uniqueConstraints={@UniqueConstraint(name="rsq_token_idx", columnNames={"accessToken"})})
@Where(clause="deleted is false")
public class LoginToken
extends PgAuditableEntity {
    private String loginId;
    private String accessToken;
    private LocalDateTime expireTime;

    public LoginToken() {
    }

    LoginToken(String loginId, String accessToken, LocalDateTime expireTime) {
        this.loginId = loginId;
        this.accessToken = accessToken;
        this.expireTime = expireTime;
    }

    public static LoginTokenBuilder builder() {
        return new LoginTokenBuilder();
    }

    public String getLoginId() {
        return this.loginId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public LocalDateTime getExpireTime() {
        return this.expireTime;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginToken)) {
            return false;
        }
        LoginToken loginToken = (LoginToken)o;
        if (!loginToken.canEqual(this)) {
            return false;
        }
        String string = this.getLoginId();
        String string2 = loginToken.getLoginId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getAccessToken();
        String string4 = loginToken.getAccessToken();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        LocalDateTime localDateTime = this.getExpireTime();
        LocalDateTime localDateTime2 = loginToken.getExpireTime();
        return !(localDateTime == null ? localDateTime2 != null : !((Object)localDateTime).equals(localDateTime2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginToken;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        String string = this.getLoginId();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getAccessToken();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        LocalDateTime localDateTime = this.getExpireTime();
        n2 = n2 * 59 + (localDateTime == null ? 43 : ((Object)localDateTime).hashCode());
        return n2;
    }

    public String toString() {
        return "LoginToken(loginId=" + this.getLoginId() + ", accessToken=" + this.getAccessToken() + ", expireTime=" + this.getExpireTime() + ")";
    }

    public static class LoginTokenBuilder {
        private String loginId;
        private String accessToken;
        private LocalDateTime expireTime;

        LoginTokenBuilder() {
        }

        public LoginTokenBuilder loginId(String loginId) {
            this.loginId = loginId;
            return this;
        }

        public LoginTokenBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public LoginTokenBuilder expireTime(LocalDateTime expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public LoginToken build() {
            return new LoginToken(this.loginId, this.accessToken, this.expireTime);
        }

        public String toString() {
            return "LoginToken.LoginTokenBuilder(loginId=" + this.loginId + ", accessToken=" + this.accessToken + ", expireTime=" + this.expireTime + ")";
        }
    }
}

