/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.controller;

import cn.patterncat.rest.ApiResult;
import cn.patterncat.rsq.config.CalciteConfig;
import cn.patterncat.rsq.domain.pg.QueryDefinition;
import java.sql.JDBCType;
import java.util.List;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/rsq-sql")
public class SqlController {
    @Autowired
    SqlAdvisor sqlAdvisor;

    @GetMapping(value={"/validate"})
    public ApiResult<List<SqlAdvisor.ValidateErrorInfo>> validateSql(@RequestBody QueryDefinition queryDefinition) {
        List list = this.sqlAdvisor.validate(queryDefinition.getSql());
        return ApiResult.success((Object)list);
    }

    @GetMapping(value={"/suggest"})
    public ApiResult<List<SqlMoniker>> sqlSuggest(@RequestBody QueryDefinition queryDefinition, int cursor) {
        List list = this.sqlAdvisor.getCompletionHints(queryDefinition.getSql(), cursor, CalciteConfig.REPLACED);
        return ApiResult.success((Object)list);
    }

    @GetMapping(value={"/jdbc-types"})
    public ApiResult<JDBCType[]> getJdbcTypes() {
        return ApiResult.success((Object)JDBCType.values());
    }
}

