/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.config;

import cn.patterncat.rsq.component.security.policy.AppIdKeyPolicy;
import cn.patterncat.rsq.component.security.policy.AuthPolicy;
import cn.patterncat.rsq.component.security.policy.IpAddressPolicy;
import cn.patterncat.rsq.component.security.policy.UserTokenPolicy;
import cn.patterncat.rsq.model.QueryAuthInfo;
import cn.patterncat.rsq.model.QueryAuthType;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"cn.patterncat.rsq.controller", "cn.patterncat.rsq.component", "cn.patterncat.rsq.service"})
public class MvcConfig {
    @Bean
    @ConditionalOnMissingBean(name={"appIdKeyPolicy"})
    public AuthPolicy appIdKeyPolicy() {
        return new AppIdKeyPolicy();
    }

    @Bean
    @ConditionalOnMissingBean(name={"ipAddressPolicy"})
    public AuthPolicy ipAddressPolicy() {
        return new IpAddressPolicy();
    }

    @Bean
    @ConditionalOnMissingBean(name={"userTokenPolicy"})
    public AuthPolicy userTokenPolicy() {
        return new UserTokenPolicy();
    }

    @Bean
    @ConditionalOnMissingBean(name={"defaultQueryAuthInfo"})
    public QueryAuthInfo defaultQueryAuthInfo() {
        return QueryAuthInfo.builder().queryAuthType(QueryAuthType.APP_ID_KEY).appIds(List.of("rql")).validateSign(false).build();
    }
}

