/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.config;

import cn.patterncat.rsq.RsqProperties;
import cn.patterncat.rsq.component.jdbc.LowerCaseRowProcessor;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.StatementConfiguration;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RsqProperties.class})
public class DbUtilsConfig {
    @Autowired
    @Qualifier(value="rsqDataSource")
    DataSource dataSource;

    @Bean
    public QueryRunner queryRunner(RsqProperties rsqProperties) {
        StatementConfiguration statementConfiguration = new StatementConfiguration.Builder().queryTimeout(Integer.valueOf(rsqProperties.getJdbc().getQueryTimeoutInSecs())).fetchDirection(Integer.valueOf(1000)).fetchSize(Integer.valueOf(rsqProperties.getJdbc().getFetchSize())).maxRows(Integer.valueOf(rsqProperties.getJdbc().getMaxRows())).maxFieldSize(Integer.valueOf(rsqProperties.getJdbc().getMaxFieldSizeInBytes())).build();
        return new QueryRunner(this.dataSource, statementConfiguration);
    }

    @Bean
    public ScalarHandler<Object> scalarHandler() {
        return new ScalarHandler();
    }

    @Bean
    public MapListHandler mapListHandler() {
        return new MapListHandler(LowerCaseRowProcessor.LOWER_CASE_ROW_PROCESSOR);
    }

    @Bean
    public MapHandler mapHandler() {
        return new MapHandler(LowerCaseRowProcessor.LOWER_CASE_ROW_PROCESSOR);
    }
}

