/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.component.security.policy;

import cn.patterncat.rsq.a.O00000o;
import cn.patterncat.rsq.component.exception.InvalidAccessException;
import cn.patterncat.rsq.component.security.policy.AuthPolicy;
import cn.patterncat.rsq.domain.pg.AppInfo;
import cn.patterncat.rsq.model.QueryAuthInfo;
import cn.patterncat.rsq.model.QueryAuthType;
import cn.patterncat.rsq.service.AppInfoService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerMapping;

public class AppIdKeyPolicy
implements AuthPolicy {
    public static final String SIGN_FORMAT = "appKey=%s&queryId=%s&timestamp=%d";
    @Autowired
    AppInfoService appInfoService;

    @Override
    public boolean match(QueryAuthType authType) {
        return QueryAuthType.APP_ID_KEY == authType;
    }

    @Override
    public void auth(QueryAuthInfo authInfo) throws InvalidAccessException {
        if (CollectionUtils.isEmpty(authInfo.getAppIds())) {
            return;
        }
        HttpServletRequest httpServletRequest = O00000o.getRequest();
        Map map = (Map)httpServletRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (map == null) {
            return;
        }
        String string = (String)map.get("queryId");
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new InvalidAccessException("queryId\u975e\u6cd5");
        }
        String string2 = httpServletRequest.getParameter("appId");
        if (StringUtils.isBlank((CharSequence)string2) || !authInfo.getAppIds().contains(string2)) {
            throw new InvalidAccessException("appId\u975e\u6cd5");
        }
        AppInfo appInfo = this.appInfoService.findByAppId(string2);
        if (appInfo == null) {
            throw new InvalidAccessException("appId\u975e\u6cd5");
        }
        if (!authInfo.isValidateSign()) {
            return;
        }
        String string3 = httpServletRequest.getParameter("timestamp");
        if (!StringUtils.isNumeric((CharSequence)string3)) {
            throw new IllegalArgumentException("timestamp\u975e\u6cd5");
        }
        long l = Long.parseLong(string3);
        long l2 = System.currentTimeMillis() - l;
        if (TimeUnit.MILLISECONDS.toSeconds(l2) > (long)authInfo.getTimeoutSecs()) {
            throw new InvalidAccessException("timestamp\u975e\u6cd5");
        }
        String string4 = httpServletRequest.getParameter("sign");
        if (StringUtils.isBlank((CharSequence)string4)) {
            throw new IllegalArgumentException("sign\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String string5 = AppIdKeyPolicy.generateSign(appInfo.getAppKey(), string, l);
        if (!string5.equals(string4)) {
            throw new InvalidAccessException("sign\u975e\u6cd5");
        }
    }

    public static String generateSign(String appKey, String queryId, long timestamp) {
        String string = String.format(SIGN_FORMAT, appKey, queryId, timestamp);
        return DigestUtils.md5Hex((String)string).toLowerCase();
    }
}

