/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.component.jdbc;

import java.util.Map;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.interceptor.AbstractQueryReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSlowQueryReport
extends AbstractQueryReport {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogSlowQueryReport.class);

    protected String reportSlowQuery(String query, Object[] args, String name, long start, long delta) {
        String string = super.reportSlowQuery(query, args, name, start, delta);
        LOGGER.error("slow sql cost:{},sql:{}", (Object)delta, (Object)string);
        return string;
    }

    protected String reportFailedQuery(String query, Object[] args, String name, long start, Throwable t) {
        String string = super.reportFailedQuery(query, args, name, start, t);
        LOGGER.error("sql failed:{}", (Object)string);
        return string;
    }

    public void setProperties(Map<String, PoolProperties.InterceptorProperty> properties) {
        super.setProperties(properties);
        String string = "threshold";
        PoolProperties.InterceptorProperty interceptorProperty = properties.get("threshold");
        if (interceptorProperty != null) {
            this.setThreshold(Long.parseLong(interceptorProperty.getValue()));
        }
    }

    protected void prepareStatement(String sql, long time) {
    }

    protected void prepareCall(String query, long time) {
    }

    public void closeInvoked() {
    }
}

